﻿using Abp.AspNetCore;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Abp.Threading.BackgroundWorkers;
using Bailun.AbpCore;
using Bailun.AbpCore.ServiceFabric;
using Bailun.Discuz;
using Bailun.Discuz.ConsoleApp.Publish.Worker;
using Bailun.Discuz.Domain.ExternalApi;
using Bailun.ServiceFabric;
using Castle.MicroKernel.Registration;
using Castle.Windsor.MsDependencyInjection;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.IO;
using Z.EntityFramework.Extensions;

namespace Bailun.Amazon.ConsoleApp.Publish
{
    [DependsOn(
        typeof(EFCoreModule),
        typeof(ApplicationModule)
    )]
    internal class ConsoleModule : AbpModule
    {
        public override void PreInitialize()
        {

            var environmentName = Environment.GetEnvironmentVariable("ASPNETCORE_ENVIRONMENT");
            var configurationBuilder = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                .AddJsonFile($"appsettings.{environmentName}.json", true, reloadOnChange: true)
                .AddEnvironmentVariables();
            var configuration = configurationBuilder.Build();

            var services = new ServiceCollection();
            var serviceProvider = WindsorRegistrationHelper.CreateServiceProvider(IocManager.IocContainer, services);

            var dbContextOptionsBuilder = new DbContextOptionsBuilder<BaseContext>();
            var conn = configuration.GetConnectionString("Discuz");
            dbContextOptionsBuilder.UseMySql(conn).UseInternalServiceProvider(serviceProvider);
            IocManager.IocContainer.Register(Component.For<DbContextOptions<BaseContext>>()
                .Instance(dbContextOptionsBuilder.Options)
                .LifestyleSingleton());
            services.AddEntityFrameworkMySql();
            EntityFrameworkManager.ContextFactory = context =>
            {
                var optionsBuilder = new DbContextOptionsBuilder<BaseContext>();
                optionsBuilder.UseMySql(conn);
                return new BaseContext(optionsBuilder.Options);
            };
            ConfigManagerConf.SetConfiguration(configuration);

            services.AddMicroServiceApi<ITaskJobApi>(ConfigManagerConf.GetValue("ApiServerUrl:TaskJobUrl"));
            services.AddMicroServiceApi<IPamsApi>(ConfigManagerConf.GetValue("ApiServerUrl:PamsUrl"));

            services.AddAbp<ConsoleModule>();

            string hostName = ConfigManagerConf.GetValue("redis:HostName");
            string port = ConfigManagerConf.GetValue("redis:Port");
            string password = ConfigManagerConf.GetValue("redis:Password");
            string defaultdatabase = ConfigManagerConf.GetValue("redis:Defaultdatabase");
            var redis_connString = $"{hostName}:{port}, defaultDatabase = {defaultdatabase},password={password}, poolsize = 500, ssl = false, writeBuffer = 10240";
            var rs = new CSRedis.CSRedisClient(redis_connString);
            RedisHelper.Initialization(rs);//初始化
            Configuration.UnitOfWork.IsTransactional = false;
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(ConsoleModule).GetAssembly());
        }

        public override void PostInitialize()
        {



            var workManager = IocManager.Resolve<IBackgroundWorkerManager>();
            var taskType = Environment.GetEnvironmentVariable("TaskType");
            Console.WriteLine($"TaskType:{taskType}");
            workManager.Add(IocManager.Resolve<PublishWeiPanWorker>());
        }
    }
}