﻿using Abp.Dependency;
using Abp.Threading.BackgroundWorkers;
using Abp.Threading.Timers;
using Bailun.Discuz.Application.Util;
using Bailun.Discuz.Application.WeiPan;
using Bailun.ServiceFabric;
using System;


namespace Bailun.Discuz.ConsoleApp.Publish.Worker
{
    public class PublishWeiPanWorker : PeriodicBackgroundWorkerBase, ISingletonDependency
    {
        private readonly IWeiPanService _weiPanService;

        public PublishWeiPanWorker(AbpTimer timer,
            IWeiPanService weiPanService) : base(timer)
        {
            _weiPanService = weiPanService;
            var minute = ConfigManagerConf.GetValue("PublishWeiPanWorkerRunTime:Minute");
            timer.Period = 1000 * 60 * Convert.ToInt32(minute);
            timer.RunOnStart = true;
        }
        protected override void DoWork()
        {
            try
            {
                Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}：开始生成帖子中");
                var result= _weiPanService.ProcessWeiPanWorker().GetAwaiter().GetResult();
                Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}：生成帖子完毕,"+ result);
            }
            catch (Exception ex)
            {
                Console.WriteLine($"生成帖子异常：{ex.Message}，异常堆栈为：{ex.StackTrace}");
            }
        }
    }
}
