﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Text;

namespace Bailun.Discuz
{
    public static class SystemKeyExtensions
    {
        /// <summary>
        /// If extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="condition"></param>
        /// <param name="action"></param>
        /// <returns></returns>
        public static T If<T>(this T t, bool condition, Action<T> action) where T : class
        {
            if (condition)
            {
                action(t);
            }

            return t;
        }

        /// <summary>
        /// If extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="predicate"></param>
        /// <param name="action"></param>
        /// <returns></returns>
        public static T If<T>(this T t, Predicate<T> predicate, Action<T> action) where T : class
        {
            if (t == null)
            {
                throw new ArgumentNullException();
            }

            if (predicate(t))
            {
                action(t);
            }

            return t;
        }

        /// <summary>
        /// If extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="condition"></param>
        /// <param name="func"></param>
        /// <returns></returns>
        public static T If<T>(this T t, bool condition, Func<T, T> func) where T : struct => condition ? func(t) : t;

        /// <summary>
        /// If extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="predicate"></param>
        /// <param name="func"></param>
        /// <returns></returns>
        public static T If<T>(this T t, Predicate<T> predicate, Func<T, T> func) where T : struct => predicate(t) ? func(t) : t;

        /// <summary>
        /// If and else extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="condition"></param>
        /// <param name="ifAction"></param>
        /// <param name="elseAction"></param>
        /// <returns></returns>
        public static T IfAndElse<T>(this T t, bool condition, Action<T> ifAction, Action<T> elseAction) where T : class
        {
            if (condition)
            {
                ifAction(t);
            }
            else
            {
                elseAction(t);
            }

            return t;
        }

        /// <summary>
        /// If and else extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="predicate"></param>
        /// <param name="ifAction"></param>
        /// <param name="elseAction"></param>
        /// <returns></returns>
        public static T IfAndElse<T>(this T t, Predicate<T> predicate, Action<T> ifAction, Action<T> elseAction) where T : class
        {
            if (t == null)
            {
                throw new ArgumentNullException();
            }

            if (predicate(t))
            {
                ifAction(t);
            }
            else
            {
                elseAction(t);
            }

            return t;
        }

        /// <summary>
        /// If and else extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="condition"></param>
        /// <param name="ifFunc"></param>
        /// <param name="elseFunc"></param>
        /// <returns></returns>
        public static T IfAndElse<T>(this T t, bool condition, Func<T, T> ifFunc, Func<T, T> elseFunc) where T : struct => condition ? ifFunc(t) : elseFunc(t);

        /// <summary>
        /// If and else extensions
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="t"></param>
        /// <param name="predicate"></param>
        /// <param name="ifFunc"></param>
        /// <param name="elseFunc"></param>
        /// <returns></returns>
        public static T IfAndElse<T>(this T t, Predicate<T> predicate, Func<T, T> ifFunc, Func<T, T> elseFunc) where T : struct => predicate(t) ? ifFunc(t) : elseFunc(t);

        public static IQueryable<T> GenericEvaluateOrderBy<T>(this IQueryable<T> query, string sort, string order = "DESC")
        {
            if (string.IsNullOrEmpty(sort))
                throw new Exception("必须指定排序字段!");

            PropertyInfo sortProperty = typeof(T).GetProperty(sort, BindingFlags.Public | BindingFlags.Instance | BindingFlags.IgnoreCase);
            if (sortProperty == null)
            {
                throw new Exception("找不到指定的排序字段");
                //sortProperty = typeof(T).GetProperty("Id", BindingFlags.Public | BindingFlags.Instance | BindingFlags.IgnoreCase);
            }
            ParameterExpression param = Expression.Parameter(typeof(T), "t");
            Expression body = param;
            if (Nullable.GetUnderlyingType(body.Type) != null)
                body = Expression.Property(body, "Value");
            body = Expression.MakeMemberAccess(body, sortProperty);
            LambdaExpression keySelectorLambda = Expression.Lambda(body, param);

            if (string.IsNullOrEmpty(order))
                order = "DESC";
            string queryMethod = order.ToUpper() == "DESC" ? "OrderByDescending" : "OrderBy";
            query = query.Provider.CreateQuery<T>(Expression.Call(typeof(Queryable), queryMethod,
                                                               new Type[] { typeof(T), body.Type },
                                                               query.Expression,
                                                               Expression.Quote(keySelectorLambda)));
            return query;
        }
    }
}