﻿using Abp;
using Abp.AspNetCore;
using Bailun.Discuz.ConsoleApp.Publish;
using Microsoft.Extensions.Hosting;
using System.Threading.Tasks;

namespace Bailun.Amazon.ConsoleApp.Publish
{
    class Program
    {
        static async Task Main(string[] args)
        {
            System.Threading.ThreadPool.SetMinThreads(200, 200);
            using (var application = AbpBootstrapper.Create<ConsoleModule>())
            {
                application.Initialize();

                var builder = new HostBuilder()
                .ConfigureLogging(logging =>
                {
                    //logging.AddConsole();
                })
                .ConfigureServices((hostContext, services) =>
                {
                    services.AddAbp<ConsoleModule>();
                });

                await builder.RunConsoleAsync();
            }
        }
    }
}
