﻿using Bailun.AbpCore.ServiceFabric;
using Bailun.Discuz.Application.Account.Dto;
using Bailun.Discuz.Application.Util;
using Bailun.Discuz.Application.WeiPan;
using Bailun.Discuz.Application.WeiPan.Dto.RequestDto;
using Bailun.Discuz.Application.WeiPan.Dto.ResponseDto;
using Bailun.Discuz.Domain.WeiPan;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using static Bailun.Discuz.Application.WeiPan.Dto.Relationships.Relationships;

namespace Bailun.Discuz.Service.Controllers
{
    public class WeiPanController: AbpApiController
    {
        private readonly IWeiPanService _iweiPanService;
        public WeiPanController(IWeiPanService weiPanService)
        {
            _iweiPanService = weiPanService;
        }
        /// <summary>
        ///  创建微盘空间并返回空间id
        /// </summary>
        /// <returns></returns>
        [HttpGet("CreateQYWechatSpace")]
        public async Task<string> CreateQYWechatSpace(string userId)
        {
            return await _iweiPanService.CreateSpace(userId);
        }
        /// <summary>
        ///  创建微盘的根目录文件夹
        /// </summary>
        /// <returns></returns>
        [HttpGet("CreateSpaceFile")]
        public async Task<CreateSpaceFileResponse> CreateSpaceFile(string userId)
        {
            return await _iweiPanService.CreateSpaceFile(userId);
        }

        ///// <summary>
        ///// 获取首层文件列表
        ///// </summary>
        ///// <returns></returns>
       [HttpGet("GetFirstFileList")]
        public async Task<GetFileListResponse> GetFirstFileList(string userId,string companyName)
        {
            return await _iweiPanService.GetFirstFileList(userId, companyName,true);
        }

        ///// <summary>
        ///// 获取首层文件列表
        ///// </summary>
        ///// <returns></returns>
        [HttpGet("GetViewFile")]
        public async Task<string> GetViewFile(string userId,string fileId, string md5,string fileName)
        {
            return await _iweiPanService.GetViewFile(userId,fileId, md5,fileName);
        }
        /// <summary>
        /// 递归获取所有首页下的所有文件列表数据
        /// </summary>
        [HttpGet("GetFileListTree")]
        public async Task<List<FileListTreeDto>> GetFileListTree(string userId, string fildId, string companyName)
        {
            return await _iweiPanService.GetFileListTree(userId, companyName,fildId);
        }

        /// <summary>
        /// 生成附件
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        [HttpGet("CreateAttachment")]
        public async Task<long> CreateAttachment(long userId, string fileMd5, long typeId)
        {
            return await _iweiPanService.CreateAttachment(userId, fileMd5,typeId);
        }

        [HttpGet("ProcessWeiPanWorker")]
        public async Task<string> ProcessWeiPanWorker(string userId,string companyName)
        {
            RedisHelper.Del(Constants.File_List_Tree);//清除缓存
            RedisHelper.Del(Constants.First_File_List);//清除缓存
            return await _iweiPanService.ProcessWeiPanWorker(userId, companyName);
        }
        [HttpGet("GetFileInfo")]
        public async Task<WeiPanFileList> GetFileInfo(string fileId)
        {
           return await _iweiPanService.GetFileInfo(fileId);
        }

        [HttpGet("GetWeiPanFileByThreadId")]
        public async Task<WeiPanFileList> GetWeiPanFileByThreadId(long threadId)
        {
            return await _iweiPanService.GetWeiPanFileByThreadId(threadId);
        }
        [HttpGet("GetAttchmattachmentByFileId")]
        public async Task<AttachmentsDto> GetAttchmattachmentByFileId(string fileId)
        {
            return await _iweiPanService.GetAttchmattachmentByFileId(fileId);
        }

        [HttpPost("GetNoticeList")]
        public async Task<GetNotificationsResponse> GetNoticeList(GetNotificationsRequest request)
        {
            return await _iweiPanService.GetNoticeList(request);
        }
    }
}
