﻿using Bailun.AbpCore.EFCore;
using Bailun.Discuz.Domain;
using Bailun.Discuz.Domain.WeiPan;
using Microsoft.EntityFrameworkCore;

namespace Bailun.Discuz
{
    public class BaseContext : AbpBaseDbContext
    {
        public BaseContext(DbContextOptions<BaseContext> options)
            : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<WeiPanFileList>(pc => pc.ToTable("dis_weipan_file_list").HasKey(k => k.Id));
            modelBuilder.Entity<Attachments>(pc => pc.ToTable("dis_attachments").HasKey(k => k.Id));
            base.OnModelCreating(modelBuilder);
        }
    }
}
