﻿using Abp.Application.Services;
using AutoMapper;
using Bailun.Discuz.Application.Account.Dto;
using Bailun.Discuz.Domain.ExternalApi;
using Bailun.Discuz.Domain.ExternalApi.ApiDtos.Account;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Bailun.Discuz.Application.Account
{
    public class AccountService : ApplicationService, IAccountService
    {
        private IPamsApi _pamsApi;
        private readonly IMapper _mapper;


        public AccountService(IPamsApi pamsApi, IMapper mapper)
        {
            _pamsApi = pamsApi;
            _mapper = mapper;
        }

        public async Task<List<ThinAccountDto>> GetPlatformAccountListAsync()
        {
            var result = await _pamsApi.GetPlatformAccount();

            return _mapper.Map<List<ThinAccountDto>>(result.Data);
        }
    }
}
