﻿using System.Linq;
using System.Threading.Tasks;
using Bailun.Discuz.Domain.Account.IRepositories;
using Bailun.Discuz.Domain.Account.ValueObject;
using Microsoft.EntityFrameworkCore;

namespace Bailun.Discuz.Domain.Account.DomainService
{
    public class AccountPublishConfigDomainService : IAccountPublishConfigDomainService
    {
        private readonly ILazadaAccountPublishConfigRepository _lazadaAccountPublishConfigRepository;

        public AccountPublishConfigDomainService(
            ILazadaAccountPublishConfigRepository lazadaAccountPublishConfigRepository
            )
        {
            _lazadaAccountPublishConfigRepository = lazadaAccountPublishConfigRepository;
        }

        public async Task<ProductPublishable> IsProductPublishable(long accountId, long categoryId, string categoryPath)
        {
            var config = await _lazadaAccountPublishConfigRepository.Query().AsNoTracking()
                .FirstOrDefaultAsync(m => m.AccountId == accountId);
            if (config == null) return new ProductPublishable {Publishable = true};

            if (config.PublishableCategories != null && config.PublishableCategories.Any() &&
                config.PublishableCategories.All(m => m.Key != categoryId))
                return new ProductPublishable {Publishable = false, Message = $"{categoryPath}不在可刊登类目"};

            if (config.UnpublishableCategories != null && config.UnpublishableCategories.Any() &&
                config.UnpublishableCategories.Any(m => m.Key == categoryId))
                return new ProductPublishable {Publishable = false, Message = $"{categoryPath}在禁售类目"};
            return new ProductPublishable {Publishable = true};
        }
    }
}