﻿using Abp.Application.Services;
using Abp.Domain.Services;
using Bailun.Discuz.Application.Account.Dto;
using Bailun.Discuz.Application.WeiPan.Dto.ResponseDto;
using Bailun.Discuz.Domain.WeiPan;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using static Bailun.Discuz.Application.WeiPan.Dto.Relationships.Relationships;

namespace Bailun.Discuz.Application.WeiPan
{
   public interface IWeiPanService: IApplicationService
    {
        /// <summary>
        ///创建微盘空间
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        Task<string> CreateSpace(string userId);
        /// <summary>
        /// 创建根目录的文件夹
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        Task<CreateSpaceFileResponse> CreateSpaceFile(string userId);
        ///// <summary>
        ///// 获取首层文件列表
        ///// </summary>
        ///// <returns></returns>
        Task<GetFileListResponse> GetFirstFileList(string userId,bool isGetRedis = true);

        ///// <summary>
        ///// 获取下载文件链接地址
        ///// </summary>
        ///// <returns></returns>
        Task<string> GetViewFile(string userId, string fileId, string md5,string fileName);

        /// <summary>
        /// 递归获取所有首页下的所有文件列表数据
        /// </summary>
        Task<List<FileListTreeDto>> GetFileListTree(string userId, string fildId,bool isGetRedis = true);

        Task<AttachmentsDto> GetAttchmattachmentByFileId(string fileId);

        /// <summary>
        /// 生成附件
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        Task<long> CreateAttachment(long userId, string fileMd5, long typeId);

        Task<List<WeiPanFileList>> GetFileList(string userId,string companyName);
        Task<string> ProcessWeiPanWorker(string userId, string companyName);
        Task<WeiPanFileList> GetWeiPanFileByThreadId(long threadId);
        Task<WeiPanFileList> GetFileInfo(string fileId);
    }
}
