﻿using Abp.AutoMapper;
using Bailun.Discuz.Domain.Account;
using Bailun.ServiceFabric;
using Newtonsoft.Json;
using System.Collections.Generic;

namespace Bailun.Discuz.Application.Account.Dto
{
    [AutoMap(typeof(LazadaAccountPublishConfig))]
    public class AccountPublishConfigPageDto
    {
        public long Id { get; set; }

        public long AccountId { get; set; }

        public string AccountName { get; set; }

        public AccountType? AccountType { get; set; }

        public string AccountTypeName
        {
            get
            {
                if (AccountType.HasValue)
                {
                    return AccountType.GetDescription();
                }

                return "";
            }
        }

        public string Market { get; set; }

        public int? OnlineCount { get; set; }

        public string PublishableCategoryJson { get; set; }

        public IEnumerable<KeyValuePair<long, string>> PublishableCategories
        {
            get
            {
                if (PublishableCategoryJson.IsNullOrEmpty())
                {
                    return new List<KeyValuePair<long, string>>();
                }

                return JsonConvert.DeserializeObject<List<KeyValuePair<long, string>>>(PublishableCategoryJson);
            }
        }

        public string UnpublishableCategoryJson { get; set; }

        public IEnumerable<KeyValuePair<long, string>> UnpublishableCategories
        {
            get
            {
                if (UnpublishableCategoryJson.IsNullOrEmpty())
                {
                    return new List<KeyValuePair<long, string>>();
                }

                return JsonConvert.DeserializeObject<List<KeyValuePair<long, string>>>(UnpublishableCategoryJson);
            }
        }
    }
}
