﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Bailun.AbpCore.ServiceFabric;
using Bailun.Discuz.Application.Account;
using Bailun.Discuz.Application.Account.Dto;
using Microsoft.AspNetCore.Mvc;

namespace Bailun.Discuz.Service.Controllers
{
    public class AccountController : AbpApiController
    {
        private readonly IAccountPublishConfigService _accountPublishConfigService;
        private readonly IAccountService _accountService;

        public AccountController(IAccountService accountService,
            IAccountPublishConfigService accountPublishConfigService)
        {
            _accountService = accountService;
            _accountPublishConfigService = accountPublishConfigService;
        }

        /// <summary>
        ///     获取全部lazada账号
        /// </summary>
        /// <returns></returns>
        [HttpGet("GetList")]
        public async Task<List<ThinAccountDto>> GetLazadaAccounts()
        {
            return await _accountService.GetPlatformAccountListAsync();
        }

        [HttpGet("GetAccountNames")]
        public async Task<IEnumerable<string>> GetAccountNames()
        {
            return await _accountPublishConfigService.GetAccountNames();
        }
    }
}