﻿using Bailun.Discuz.Application.WeiPan.Dto;
using System;
using System.Collections.Generic;
using System.Text;
using Bailun.ServiceFabric;
using Abp.Application.Services;
using System.Threading.Tasks;
using Bailun.Discuz.Application.WeiPan.Dto.ResponseDto;
using Bailun.Discuz.Application.WeiPan.Dto.RequestDto;
using Bailun.Discuz.Domain.WeiPan;
using Bailun.Discuz.Domain.WeiPan.IRepositories;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using AutoMapper;
using System.Net;
using System.Net.Http;
using System.IO;
using System.Web;
using System.Text.RegularExpressions;
using Bailun.Discuz.Application.Helper;
using Bailun.Discuz.Domain;
using Bailun.Discuz.Application.WeiPan.Dto.RequestDto.PublishTieZiRequest;
using Bailun.Discuz.Application.WeiPan.Dto.PublishTieZiResponse;
using System.Net.Http.Headers;
using Newtonsoft.Json;
using Bailun.Discuz.Application.Util;
using Abp.Domain.Uow;
using Abp.Domain.Services;
using Users = Bailun.Discuz.Domain.WeiPan.Users;
using Bailun.Discuz.Application.Account.Dto;

namespace Bailun.Discuz.Application.WeiPan
{
    [UnitOfWork(false)]
    public class WeiPanService : ApplicationService, IWeiPanService
    {
        private readonly IWeiPanFileListRepository _weiPanFileListRepository;
        private readonly IAttachmentsRepository _attachmentsRepository;
        private readonly IWeipanUserFilesRepository _weipanUserFilesRepository;
        private readonly IUsersRepository _usersRepository;


        private readonly IMapper _mapper;
        public WeiPanService(IWeiPanFileListRepository weiPanFileListRepository, IMapper mapper, IAttachmentsRepository attachmentsRepository, IWeipanUserFilesRepository weipanUserFilesRepository, IUsersRepository usersRepository)
        {
            _weiPanFileListRepository = weiPanFileListRepository;
            _attachmentsRepository = attachmentsRepository;
            _weipanUserFilesRepository=weipanUserFilesRepository;
            _usersRepository=usersRepository;
            _mapper = mapper;
        }
        public async Task<string> CreateSpace(string userId)
        {
            var token = GetQYWeChatToken(userId);
            SpaceCreateRequest resquest = new SpaceCreateRequest();
            resquest.space_name = "我的微盘";
            resquest.userid = userId;
            var apiUrl = $"https://qyapi.weixin.qq.com/cgi-bin/wedrive/space_create?access_token={token}";
            var apiOutput = HttpHelper.PostAsync<SpaceCreateRequest, SpaceCreateResponse>(apiUrl, resquest);
            return apiOutput.spaceid;
        }

        /// <summary>
        /// 创建根目录的文件夹
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public async Task<CreateSpaceFileResponse> CreateSpaceFile(string userId)
        {
            var token = GetQYWeChatToken(userId);
            string apiUrl = $"https://qyapi.weixin.qq.com/cgi-bin/wedrive/file_create?access_token={token}";
            CreateSpaceFileRequest createSpaceFileRequest = new CreateSpaceFileRequest();
            var weiPanSpaceId = ConfigManagerConf.GetValue("QYWeChat:WeiPanSpaceId");
            createSpaceFileRequest.fatherid = weiPanSpaceId;
            createSpaceFileRequest.file_name = "我的共享文件";
            createSpaceFileRequest.file_type = 1;
            createSpaceFileRequest.userid = userId;
            createSpaceFileRequest.spaceid = weiPanSpaceId;
            var apiOutput = HttpHelper.PostAsync<CreateSpaceFileRequest, CreateSpaceFileResponse>(apiUrl, createSpaceFileRequest);
            return apiOutput;
        }


        /// <summary>
        /// 获取对应得用户中文名称
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public GetUsersByWxUserIdsResponse CreateRealNameByUseId(List<string> wxUserIds)
        {
            string apiUrl = $"https://sso.bailuntec.com/GetUsersByWxUserIds";
            GetUsersByWxUserIdsRequest getUsersByWxUserIdsRequest = new GetUsersByWxUserIdsRequest();
            getUsersByWxUserIdsRequest.WxUserIds = wxUserIds;
            var apiOutput = HttpHelper.PostAsync<GetUsersByWxUserIdsRequest, GetUsersByWxUserIdsResponse>(apiUrl, getUsersByWxUserIdsRequest);
            return apiOutput;
        }

        /// <summary>
        /// 生成附件
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public async Task<long> CreateAttachment(long userId, string fileId, long typeId)
        {
            var file =await GetWeiPanFile(fileId);
            if (file != null)
            {
                Attachments attachments = new Attachments();
                attachments.Uuid = fileId;
                attachments.UserId = userId;
                attachments.TypeId = typeId;
                attachments.IsRemote = 0;
                attachments.IsApproved = 1;
                attachments.Attachment = file.FileName;
                attachments.FilePath = file.QiniuUrl;
                attachments.FileName = file.FileName;
                attachments.FileSize = 0;
                attachments.FileType = "application/msword";
                attachments.Ip = "";
                attachments.CreatedAt = DateTime.Now;
                attachments.UpdatedAt = DateTime.Now;
                return  await _attachmentsRepository.InsertAndGetIdAsync(attachments);
            }
            else
            {
                throw new Exception("文件不存在,请重新刷新发帖");
            }
        }


        ///// <summary>
        ///// 获取首层文件列表
        ///// </summary>
        ///// <returns></returns>
        public async Task<GetFileListResponse> GetFirstFileList(string userId,bool isGetRedis=true)
        {
           
            //判断缓存中是否有值，如果有值直接读取
            var redisKey = Constants.First_File_List;
            GetFileListResponse cachingResponse = null;
            if(isGetRedis)
            {
                cachingResponse = RedisHelper.HGet<GetFileListResponse>(redisKey, userId);
            }
            if (cachingResponse != null)
            {
                return cachingResponse;
            }
            else
            {
                GetFileListRequest getFileListRequest = new GetFileListRequest();
                getFileListRequest.fatherid = ConfigManagerConf.GetValue("QYWeChat:WeiPanSpaceFileId");
                getFileListRequest.userid = userId;
                getFileListRequest.spaceid = ConfigManagerConf.GetValue("QYWeChat:WeiPanSpaceId");
                getFileListRequest.sort_type = 6;
                getFileListRequest.start = 0;
                getFileListRequest.limit = 1000;
                var token = GetQYWeChatToken(userId);
                var apiUrl = $"https://qyapi.weixin.qq.com/cgi-bin/wedrive/file_list?access_token={token}";
                var apiOutput = HttpHelper.PostAsync<GetFileListRequest, GetFileListResponse>(apiUrl, getFileListRequest);
                //var request=getFileListRequest.ToJson();
                if (apiOutput.file_list != null)
                {
                    apiOutput.file_list.item = apiOutput.file_list.item.Where(u => u.file_status == "1").ToList();//没被删除的文件
                    var wxUserIdsResponse = CreateRealNameByUseId(apiOutput.file_list.item.GroupBy(u => u.create_userid).Select(u => u.Key).ToList());
                    List<ResultItem> realNames = new List<ResultItem>();
                    if (wxUserIdsResponse.statusCode == 200)
                    {
                        realNames = wxUserIdsResponse.result;
                    }
                    apiOutput.file_list.item.ForEach(u =>
                    {
                        var user = realNames.Where(r => r.wxUserId == u.create_userid).FirstOrDefault();
                        if (user != null)
                        {
                            u.create_user_name = user.userName;
                        }
                        else
                        {
                            u.create_user_name = user.wxUserId;
                        }
                        u.ctime = ConvertToDateTime(u.ctime);
                    });
                }
                if(isGetRedis)
                    RedisHelper.HSet(redisKey, userId, apiOutput);
                return apiOutput;
            }
        }
        /// <summary>
        /// Unix时间戳转换为DateTime
        /// </summary>
        private string ConvertToDateTime(string timestamp)
        {
            System.DateTime time = System.DateTime.MinValue;
            //精确到毫秒
            //时间戳转成时间
            DateTime start = TimeZone.CurrentTimeZone.ToLocalTime(new System.DateTime(1970, 1, 1));
            try
            {
                time = timestamp.Length == 10 ? start.AddSeconds(long.Parse(timestamp)) : start.AddMilliseconds(long.Parse(timestamp));
            }
            catch (Exception ex)
            {
                return "";
            }
            return string.Format("{0:G}", time); ;
        }

        ///// <summary>
        ///// 获取首层下的对应树状内容
        ///// </summary>
        ///// <returns></returns>
        public GetFileListResponse RequestFileList(string userId, string fatherid, int start, string token)
        {
            GetFileListRequest getFileListRequest = new GetFileListRequest();
            getFileListRequest.fatherid = fatherid; ;
            getFileListRequest.userid = userId;
            getFileListRequest.spaceid = ConfigManagerConf.GetValue("QYWeChat:WeiPanSpaceId");
            getFileListRequest.sort_type = 6;
            getFileListRequest.start = start;
            getFileListRequest.limit = 1000;
            var apiUrl = $"https://qyapi.weixin.qq.com/cgi-bin/wedrive/file_list?access_token={token}";
            var apiOutput = HttpHelper.PostAsync<GetFileListRequest, GetFileListResponse>(apiUrl, getFileListRequest);
            return apiOutput;
        }

        /// <summary>
        /// 递归获取所有首页下的所有文件列表数据
        /// </summary>
        public async Task<List<FileListTreeDto>> GetFileListTree(string userId, string fildId)
        {
            List<FileListTreeDto> fileListTreeDtos = new List<FileListTreeDto>();
            //判断缓存中是否有值，如果有值直接读取
            var redisKey = Constants.File_List_Tree;
            var cachingResponse = RedisHelper.HGet<List<FileListTreeDto>>(redisKey, userId+"_"+ fildId);
            if (cachingResponse != null)
            {
                return cachingResponse;
            }
            else
            {
                await _weipanUserFilesRepository.DeleteAsync(u => u.UserId ==userId&&u.FatherFileId==fildId);
                var token = GetQYWeChatToken(userId);
                var apiOutput = RequestFileList(userId, fildId, 0, token);
                if (apiOutput.errcode == "0")//获取成功
                {
                    if (apiOutput.file_list != null)
                    {
                        var files = apiOutput.file_list.item;
                        if (files != null)
                        {
                            foreach (var u in files)
                            {
                                if (u.file_status == "1")//没被删除的文件
                                {
                                    FileListTreeDto fileListTreeDto = new FileListTreeDto();
                                    fileListTreeDto.id = u.fileid;
                                    fileListTreeDto.label = Path.GetFileNameWithoutExtension(u.file_name);
                                    fileListTreeDto.file = u.file_type != 1 ? true : false;
                                    fileListTreeDto.md5 = u.md5;
                                    fileListTreeDto.icon = u.file_type == 1 ? "el-icon-folder-opened" : "el-icon-document";
                                    fileListTreeDto.key = u.fileid;
                                    fileListTreeDtos.Add(fileListTreeDto);
                                }
                                if (u.file_type != 1)
                                {
                                    WeipanUserFiles weipanUserFiles = new WeipanUserFiles();
                                    weipanUserFiles.UserId = userId;
                                    weipanUserFiles.FatherFileId = fildId;
                                    weipanUserFiles.File_Id = u.fileid;
                                    await _weipanUserFilesRepository.AddAsync(weipanUserFiles, true);
                                }
                            }
                        }

                        //获取到第二层目录数据后获取每个子集数据
                        if (fileListTreeDtos.Count > 0)
                        {
                            foreach (var u in fileListTreeDtos)
                            {
                                u.children = await GetChildrens(userId, u.id, token, 0, fildId);
                            }

                        }
                    }
                    else
                    {
                        //获取文件信息
                        var fileInfo = GetFileInfo(token, fildId, userId);
                        FileListTreeDto fileListTreeDto = new FileListTreeDto();
                        fileListTreeDto.id = fildId;
                        fileListTreeDto.label = fileInfo.file_info.file_name;
                        fileListTreeDto.file = fileInfo.file_info.file_type != 1 ? true : false;
                        fileListTreeDto.md5 = fileInfo.file_info.md5;
                        fileListTreeDto.key = fildId;
                        fileListTreeDtos.Add(fileListTreeDto);
                    }

                }
                else
                {
                    throw new Exception(apiOutput.errmsg);
                }
                RedisHelper.HSet(redisKey, userId + "_" + fildId, fileListTreeDtos);
            }
            return fileListTreeDtos;
        }
        public GetFileInfoResponse GetFileInfo(string token, string fildId, string userId)
        {
            GetFileInfoRequest getFileInfoRequest = new GetFileInfoRequest();
            getFileInfoRequest.userid = userId;
            getFileInfoRequest.fileid = fildId;
            var apiUrl = $"https://qyapi.weixin.qq.com/cgi-bin/wedrive/file_info?access_token={token}";
            var apiOutput = HttpHelper.PostAsync<GetFileInfoRequest, GetFileInfoResponse>(apiUrl, getFileInfoRequest);
            return apiOutput;
        }

        /// <summary>
        /// 递归获取
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="fatherid"></param>
        /// <param name="token"></param>
        /// <param name="start"></param>
        /// <returns></returns>
        public async  Task<List<FileListTreeDto>> GetChildrens(string userId, string fatherid, string token, int start,string parentId)
        {

            List<FileListTreeDto> fileListTreeDtos = new List<FileListTreeDto>();
            #region 模拟数据
            //FileListTreeDto fileListTreeDto1 = new FileListTreeDto();
            //fileListTreeDto1.id = "aaa";
            //fileListTreeDto1.label = "文件夹";
            //fileListTreeDto1.file = false;
            //fileListTreeDto1.md5 = "aaaaaa";
            //fileListTreeDto1.icon = "el-icon-folder-opened";
            //fileListTreeDtos.Add(fileListTreeDto1);
            //FileListTreeDto fileListTreeDto2 = new FileListTreeDto();
            //fileListTreeDto2.id = "aaa";
            //fileListTreeDto2.label = "在线listing改0数据.xlsx";
            //fileListTreeDto2.file = true;
            //fileListTreeDto2.md5 = "8bda796a7cbd3335bf2cf7210cf92566";
            //fileListTreeDto2.icon = "el-icon-document";
            //fileListTreeDtos.Add(fileListTreeDto2);
            //return fileListTreeDtos;
            #endregion
            var apiOutput = RequestFileList(userId, fatherid, start, token);
            if (apiOutput.file_list != null)
            {
                var files = apiOutput.file_list.item;
                if (files != null)
                {

                    foreach (var i in files)
                    {
                        if (i.file_status == "1")//没被删除的文件
                        {
                            FileListTreeDto fileListTreeDto = new FileListTreeDto();
                            fileListTreeDto.id = i.fileid;
                            fileListTreeDto.label = Path.GetFileNameWithoutExtension(i.file_name);
                            fileListTreeDto.file = i.file_type != 1 ? true : false;
                            fileListTreeDto.md5 = i.md5;
                            fileListTreeDto.icon = i.file_type == 1 ? "el-icon-folder-opened" : "el-icon-document";
                            fileListTreeDto.key = i.fileid;
                            fileListTreeDtos.Add(fileListTreeDto);
                        }
                        if (i.file_type != 1)
                        {
                            WeipanUserFiles weipanUserFiles = new WeipanUserFiles();
                            weipanUserFiles.UserId = userId;
                            weipanUserFiles.FatherFileId = parentId;
                            weipanUserFiles.File_Id = i.fileid;
                            await _weipanUserFilesRepository.AddAsync(weipanUserFiles, true);
                        }
                    }
                }
            }
            else
            {
                return fileListTreeDtos;
            }

            foreach (var item in fileListTreeDtos)
            {
                item.children =await GetChildrens(userId, item.id, token, start,parentId);
            }
            return fileListTreeDtos;
        }


        public async Task<WeiPanFileList> GetFileInfo(string fileId)
        {
            return await GetWeiPanFile(fileId);
        }

        ///// <summary>
        ///// 获取下载文件链接地址
        ///// </summary>
        ///// <returns></returns>
        public async Task<string> GetViewFile(string userId, string fileId, string md5, string fileName)
        {
            string fileUrl = "";
                // string fileUrl =(await GetFileUrl(md5))?.QiniuUrl;
                //if (fileUrl == null)
                //  {
                GetViewFileReuqest getViewFileRequest = new GetViewFileReuqest();
                getViewFileRequest.userid = userId;
                getViewFileRequest.fileid = fileId;

                var token = GetQYWeChatToken(userId);
                var apiUrl = $"https://qyapi.weixin.qq.com/cgi-bin/wedrive/file_download?access_token={token}";
                var apiOutput = HttpHelper.PostAsync<GetViewFileReuqest, GetViewFileResponse>(apiUrl, getViewFileRequest);
                //上传至七牛云中
                if (apiOutput.errcode == 0)
                {

                    Dictionary<string, string> parameters = new Dictionary<string, string>();
                    CookieContainer cookieContainer = new CookieContainer();
                    Cookie cookie = new Cookie(apiOutput.cookie_name, apiOutput.cookie_value);
                    var domain = apiOutput.download_url.IndexOf("com/");
                    cookie.Domain = apiOutput.download_url.Substring(8, domain - 5);
                    cookieContainer.Add(cookie);   // 加入Cookie
                    HttpClientHandler httpClientHandler = new HttpClientHandler()
                    {
                        CookieContainer = cookieContainer,
                        AllowAutoRedirect = true,
                        UseCookies = true
                    };
                    var path = apiOutput.download_url;
                    HttpClient client = new HttpClient(httpClientHandler);
                    client.BaseAddress = new Uri(path);
                    var resBytes = await client.GetByteArrayAsync(path);
                    var uploadFileName = md5 + Path.GetExtension(fileName);
                    var result = await QiNiuHelper.UploadStreamAsync(uploadFileName, resBytes);
                    if (result.Code == 200)
                    {
                        fileUrl = $"http://img.blsct.com/{uploadFileName}";
                        //存入至表中
                        //WeiPanFileList weiPanFileList = new WeiPanFileList();
                        //weiPanFileList.CreateTime = DateTime.Now;
                        //weiPanFileList.FileId = fileId;
                        //weiPanFileList.FileMd5 = md5;
                        //weiPanFileList.FileName = fileName;
                        //weiPanFileList.QiniuUrl = fileUrl;
                        //await _weiPanFileListRepository.AddAsync(weiPanFileList, true);
                    }
                    else
                    {
                        throw new Exception(result.RefText);
                    }

                }
                else
                {
                    throw new Exception(apiOutput.errmsg);
                }
           // }
            return fileUrl;
        }

        /// <summary>
        /// 从数据库中获取对应得文件地址
        /// </summary>
        /// <param name="md5"></param>
        /// <returns></returns>
        public async Task<AttachmentsDto> GetAttchmattachmentByFileId(string fileId)
        {
            var attchment=await _attachmentsRepository.Query().AsNoTracking().Where(u => u.Uuid == fileId).OrderByDescending(u=>u.Id).FirstOrDefaultAsync();
            AttachmentsDto attachmentsDto = new AttachmentsDto();
            attachmentsDto.attachment = attchment.Attachment;
            attachmentsDto.extension = Path.GetExtension(attchment.Attachment);
            attachmentsDto.fileName= attchment.Attachment;
            attachmentsDto.filePath = attchment.Attachment;
            attachmentsDto.fileSize = 0;
            attachmentsDto.fileType = attchment.FileType;
            attachmentsDto.id = attchment.Id;
            attachmentsDto.isApproved = 1;
            attachmentsDto.isRemote = false;
            attachmentsDto.order = 0;
            attachmentsDto.thumbUrl = attchment.FilePath;
            attachmentsDto.type = 0;
            attachmentsDto.type_id = attchment.FilePath;
            attachmentsDto.url = attchment.FilePath;
            return attachmentsDto;
        }

        /// <summary>
        /// 从数据库中获取对应得文件地址
        /// </summary>
        /// <param name="md5"></param>
        /// <returns></returns>
        private async Task<WeiPanFileList> GetFileUrl(string md5)
        {
            return await _weiPanFileListRepository.Query().AsNoTracking().Where(u => u.FileMd5 == md5).FirstOrDefaultAsync();
        }
        /// <summary>
        /// 从数据库中获取对应得文件地址
        /// </summary>
        /// <param name="md5"></param>
        /// <returns></returns>
        public async Task<WeiPanFileList> GetWeiPanFileByThreadId(long threadId)
        {
            return await _weiPanFileListRepository.Query().AsNoTracking().Where(u => u.ThreadId == threadId).FirstOrDefaultAsync();
        }

        /// <summary>
        /// 从数据库中获取对应的FileId
        /// </summary>
        /// <param name="md5"></param>
        /// <returns></returns>
        private async Task<WeiPanFileList> GetWeiPanFile(string fileId)
        {
            return await _weiPanFileListRepository.Query().AsNoTracking().Where(u => u.FileId == fileId).FirstOrDefaultAsync();
        }

        private string GetQYWeChatToken(string userId)
        {
            var appId = ConfigManagerConf.GetValue("QYWeChat:AppId");
            var secret = ConfigManagerConf.GetValue("QYWeChat:Secret");
            var url = $"https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid={appId}&corpsecret={secret}";
            var response = HttpHelper.HttpGet(url);
            var result = JsonHelper.FromJson<GettokenResponse>(response);
            return result.access_token;
        }

        /// <summary>
        /// 处理微盘自动发帖功能
        /// </summary>

        public async Task<string> ProcessWeiPanWorker()
        {
            StringBuilder messageSb = new StringBuilder(); ;
            string userId = "chenzekai";
            List<WeiPanFileList> inserWeiPanFileList = new List<WeiPanFileList>();
            //1:获取线上的所有文档数据
            var filList=await GetFileList();

            //string value = "测试数据";
           //RedisHelper.Set("key", filList);
           // List<WeiPanFileList> filList = RedisHelper.Get<List<WeiPanFileList>>("key");
            //filList.RemoveAt(1);
            //2：判断当前fileid是否存在于数据库中， 如果不存在则添加
            foreach (var file in filList)
            {
                var weiPanFile =await GetWeiPanFile(file.FileId);
                if (weiPanFile== null)
                {
                    //将文档上传至七牛云
                    string fileUrl = await GetViewFile(userId, file.FileId, file.FileMd5, file.FileName);
                    file.QiniuUrl = fileUrl;
                    inserWeiPanFileList.Add(file);
                }else
                {
                    //判断当前的md5是否一致，如果不一致则要更新URL地址
                    if(weiPanFile.FileMd5!=file.FileMd5)
                    {
                        messageSb.Append($"修改了文件:{weiPanFile.FileName};");
                        //重新上传至七牛云
                        weiPanFile.QiniuUrl = await GetViewFile(userId, file.FileId, file.FileMd5, file.FileName);
                        //更新附件表
                        //var typeId =weiPanFile.ThreadId;
                        //if(typeId>0)
                        //{
                            var attachment=await _attachmentsRepository.Query().AsNoTracking().Where(u => u.Uuid == weiPanFile.FileId).OrderByDescending(u=>u.CreatedAt).FirstOrDefaultAsync();
                            if(attachment!=null)
                            {
                                attachment.FilePath = weiPanFile.QiniuUrl;
                                attachment.Attachment = weiPanFile.FileName;
                                attachment.FileName = weiPanFile.FileName;
                                 _attachmentsRepository.Update(attachment);
                            }
                        //}
                        //更新表md5值
                        weiPanFile.FileMd5 = file.FileMd5;
                        weiPanFile.FileName = file.FileName;
                        _weiPanFileListRepository.Update(weiPanFile);
                    } 
                }
            }

            //判断线上文件列表数据是否有删除，如果有删除要进行同步删除
            var fileList= await _weiPanFileListRepository.Query().AsNoTracking().ToListAsync();
            var onLineFileIds = filList.Select(u => u.FileId).ToArray();
            var delFiles=fileList.Where(u => !onLineFileIds.Contains(u.FileId)).ToList();
            if(delFiles.Any())
            {
                messageSb.Append($"删除帖子数量为:{delFiles.Count},分别为:{string.Join(",", delFiles.Select(u => u.FileName).ToArray()) };");
                foreach (var item in delFiles)
                {
                    await _weiPanFileListRepository.DeleteAsync(item);
                }
            }

            if (inserWeiPanFileList.Count>0|| delFiles.Any())//有新增则清除缓存
            {
                messageSb.Append($"新增帖子数量为:{inserWeiPanFileList.Count},分别为:{string.Join(",", inserWeiPanFileList.Select(u => u.FileName).ToArray()) };");
                RedisHelper.Del(Constants.File_List_Tree);//清除缓存
                RedisHelper.Del(Constants.First_File_List);//清除缓存
            }
           await CreateUserFilesTreeRedis();
            _weiPanFileListRepository.BulkInsert(inserWeiPanFileList.ToArray());
            var noTieZilist=await _weiPanFileListRepository.Query().AsNoTracking().Where(u => u.ThreadId == 0).ToListAsync();
            foreach (var item in noTieZilist)
            {
                //对新增的文档进行创建帖子
                var threadId=await PublishTieZi(item);
                if(!string.IsNullOrEmpty(threadId))
                {
                    item.ThreadId = Convert.ToInt64(threadId);
                    await _weiPanFileListRepository.UpdateAsync(item);
                }
            }
            filList = null;
            return messageSb.Length==0?"无新增帖子":messageSb.ToString();
        }

        public void PostNoticeByNewTieZi(List<string>userNames,string threadId,string token)
        {
            if(userNames.Any())
            {
                PostTieZiRequest postTieZiRequest = new PostTieZiRequest();
                postTieZiRequest.data = new Dto.Data();
                postTieZiRequest.data.attributes = new Dto.Attributes();
                postTieZiRequest.data.attributes.content = string.Join(" ", userNames);
                postTieZiRequest.data.relationships = new Dto.RequestDto.PostTieZiRelationships.Relationships();
                postTieZiRequest.data.relationships.thread = new Dto.RequestDto.PostTieZiRelationships.Thread();
                postTieZiRequest.data.relationships.thread.data = new Dto.RequestDto.PostTieZiRelationships.Data();
                postTieZiRequest.data.relationships.thread.data.id = threadId;
                postTieZiRequest.data.relationships.thread.data.type = "threads";
                var apiUrl = $"http://discuz.bailuntec.com/api/posts";
                var res=Client_Post(postTieZiRequest.ToJson(), apiUrl, "Bearer " + token);
            }
        }

        /// <summary>
        /// 创建缓存数据
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public async Task<string> CreateUserFilesTreeRedis()
        {
            var userList = await _usersRepository.Query().AsNoTracking().ToListAsync();
            foreach (var item in userList)
            {
                if(item.UserId!=null)
                {
                    List<string> fileIds = new List<string>();
                    //获取用户对于的首层文件列表
                    var firstFiles = await GetFirstFileList(item.UserId);
                    if (firstFiles.file_list != null)
                    {
                        foreach (var file in firstFiles.file_list.item)
                        {
                            
                            await GetFileListTree(item.UserId, file.fileid);
                        }
                    }
                }
            }
            return null;
        }

        public async Task<List<string>> GetNoticeUserNames(string fileId)
        {
            List<string> result = new List<string>();
            var userFiles = await _weipanUserFilesRepository.Query().AsNoTracking().Where(u => u.File_Id == fileId).ToListAsync();
            foreach (var item in userFiles)
            {
                var user = await _usersRepository.Query().AsNoTracking().Where(i => i.UserId == item.UserId).FirstOrDefaultAsync();
                if (user != null)
                {
                    result.Add("@"+user.UserName);
                }
            }
            return result;
        }
        public async Task<string> PublishTieZi(WeiPanFileList weiPanFile)
        {
            string resultId = "";
            //获取token
            var response = HttpHelper.HttpGet($"http://discuz.bailuntec.com/api/login?useid={weiPanFile.FileCreateUseid}");
            var result = JsonHelper.FromJson<GetDiscuzTokenRespnse>(response);
            var token= result.data.attributes.access_token;
            //生成附件
            var attachmentid = await CreateAttachment(result.data.id, weiPanFile.FileId, 0);
            if (!string.IsNullOrEmpty(token))
            {
                //发布帖子
                PublishTieZiRequest publishTieZiRequest = new PublishTieZiRequest();
                var data = new Dto.RequestDto.PublishTieZiRequest.Data();
                data.relationships = new Dto.Relationships.Relationships();
                data.relationships.attachments = new Dto.Relationships.Relationships.Attachments();
                data.relationships.attachments.data = new List<Dto.Relationships.Relationships.DataItem>();
                data.relationships.attachments.data.Add(new Dto.Relationships.Relationships.DataItem { id = attachmentid, type = "attachments" });
                data.relationships.category = new Dto.Relationships.Relationships.Category();
                data.relationships.category.data = new Dto.Relationships.Relationships.Data();
                data.relationships.category.data.id = 2;
                data.relationships.category.data.type = "categories";
                data.type = "threads";
                data.attributes = new Dto.RequestDto.PublishTieZiRequest.Attributes();
                data.attributes.type = 1;
                data.attributes.attachment_price = 0;
                data.attributes.title = Path.GetFileNameWithoutExtension(weiPanFile.FileName);
                data.attributes.content = Path.GetFileNameWithoutExtension(weiPanFile.FileName);
                data.attributes.free_words = 0;
                data.attributes.latitude = "";
                data.attributes.longitude = "";
                data.attributes.location = "";
                data.attributes.price = 0;
                publishTieZiRequest.data = data;
                var apiUrl = $"http://discuz.bailuntec.com/api/threads";
                var res = JsonHelper.ToObject<PublishTieZiResponse>(Client_Post(publishTieZiRequest.ToJson(), apiUrl, "Bearer " + token));
                //通知对应的用户
                var users = await GetNoticeUserNames(weiPanFile.FileId);
                resultId = res.data.id;
                PostNoticeByNewTieZi(users, resultId, token);
            }
            return resultId;
        }
        /// <summary>
        /// 公共方法—— 发送http post请求  2020年6月2日11:20:42  Dennyhui
        /// </summary>
        /// <param name="formData">参数</param>
        /// <param name="requestUri">请求地址</param>
        /// <param name="token">身份验证秘钥，可为空</param>
        /// <returns></returns>
        public  string Client_Post(string formData, string requestUri, string token)
        {
            var client = new HttpClient();
            //添加请求头
            if (!string.IsNullOrWhiteSpace(token))
            {
                client.DefaultRequestHeaders.Add("Authorization", token);
            }
            var data = Encoding.UTF8.GetBytes(formData);
            var content = new ByteArrayContent(data);
            content.Headers.ContentType = new MediaTypeHeaderValue("application/json");
            HttpResponseMessage response = client.PostAsync(requestUri, content).Result;
            return  response.Content.ReadAsStringAsync().Result;
        }

        List<ItemItem> fileItems = new List<ItemItem>();
        //}
        /// <summary>
        /// 递归获取
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="fatherid"></param>
        /// <param name="token"></param>
        /// <param name="start"></param>
        /// <returns></returns>
        public List<ItemItem> GetChildrensItem(string userId, string fatherid, string token, int start,string firstFileId)
        {
           
            var apiOutput = RequestFileList(userId, fatherid, start, token);
            if (apiOutput.file_list != null)
            {
                var files = apiOutput.file_list.item;
                if (files != null)
                {
                    files.ForEach(i =>
                    {
                        if(i.file_type!=1 && i.file_status == "1")
                        {
                            i.firstfileid = firstFileId;
                            fileItems.Add(i);
                        }
                        
                    });
                }
            }
            else
            {
                return fileItems;
            }

           var nextItems= apiOutput.file_list.item.Where(u => u.file_status=="1" && u.file_type == 1).ToList();

            foreach (var item in nextItems)
            {
                GetChildrensItem(userId, item.fileid, token, start, firstFileId);
            }
            return fileItems;
        }
        /// <summary>
        /// 递归获取所有首页下的所有文件列表数据
        /// </summary>
        public async Task<List<WeiPanFileList>> GetFileList()
        {
            string userId = "chenzekai";
            List<WeiPanFileList> weiPanFileLists = new List<WeiPanFileList>();
            List<ItemItem> itemItems = new List<ItemItem>();
            var token = GetQYWeChatToken(userId);
            var firstFiles = await GetFirstFileList(userId,false);
            if (firstFiles.file_list != null)
            {
                firstFiles.file_list.item.ForEach(u =>
                {
                    u.firstfileid = u.fileid;
                    if (u.file_type != 1&&u.file_status=="1")//说明是文件
                    {
                        itemItems.Add(u);
                    }
                    else
                    {
                        GetChildrensItem(userId, u.fileid, token, 0,u.firstfileid);
                      
                    }
                });
            }
            itemItems.AddRange(fileItems);
            itemItems.ForEach(u=> {
                    WeiPanFileList weiPanFile = new WeiPanFileList();
                    weiPanFile.CreateTime = DateTime.Now;
                    weiPanFile.FileId = u.fileid;
                    weiPanFile.FileMd5 = u.md5;
                    weiPanFile.FileName =u.file_name;
                    weiPanFile.FirstFileId = u.firstfileid;
                    weiPanFile.QiniuUrl ="";
                    weiPanFile.FileCreateUseid = u.create_userid;
                    weiPanFileLists.Add(weiPanFile);
                });
            return weiPanFileLists;
        }
    }
}  
